<?php
require_once(WCF_DIR.'lib/system/event/EventListener.class.php');

class PostVernetzung implements EventListener {

	private $djoVersion = '1.0';
	private $cacheVorhalt = 4; # (Tage) Wann ein vernetzter Text aus dem Cache entfernt und neu vernetzt werden soll
	private $djoAktenzeichenIgnorieren, $cacheTable;
	/**
	 * @see EventListener::execute()
	 */
	public function execute($eventObj, $className, $eventName) {
		$admin = new User(1);
		$this->adminMail = $admin->email;
		$parser = MessageParser::getInstance();
		$parser->setOutputType('text/html');
		$this->cacheTable = 'wbb3_dejure_cache';

		$countPosts = count($eventObj->postList->posts);
		for ($i = 0; $i < $countPosts; $i++) {
			AttachmentBBCode::setMessageID($eventObj->postList->posts[$i]->postID);
			$eventObj->postList->posts[$i]->message = $parser->parse($eventObj->postList->posts[$i]->message);
			$eventObj->postList->posts[$i]->messageCache = $this->djo_vernetzung($eventObj->postList->posts[$i]->message);
		}
	}

	private function djo_vernetzung($ausgabetext = null) {
		$anbieterkennung = PAGE_TITLE; # Hier eine feste Bezeichnung für Ihren Dienst zur Kommunikation mit dejure.org festlegen (Buchstaben und Zahlen erlaubt, mindestens 5 Stellen)
		$kontaktemail = $this->adminMail; # Wird im Rahmen der Serverkommunikation jeweils an dejure.org übertragen und dient im übrigen nur der Kommunikation bei technischen Problemen. dejure.org wird die Daten nicht an Dritte weitergeben oder für Werbezwecke o.ä. verwenden
		$target = '_blank'; # Wird im Rahmen der Serverkommunikation jeweils an dejure.org übertragen und dient im übrigen nur der Kommunikation bei technischen Problemen. dejure.org wird die Daten nicht an Dritte weitergeben oder für Werbezwecke o.ä. verwenden
		$class = ''; # Wird im Rahmen der Serverkommunikation jeweils an dejure.org übertragen und dient im übrigen nur der Kommunikation bei technischen Problemen. dejure.org wird die Daten nicht an Dritte weitergeben oder für Werbezwecke o.ä. verwenden
		$rueckgabe = $this->vernetzen_ueber_cache($ausgabetext);
		if (empty($rueckgabe)) {
			$rueckgabe = $this->vernetzen_ueber_dejure_org(
				$ausgabetext, 
				array(
					'Anbieterkennung' => $anbieterkennung.'__'.$kontaktemail,
					'target' => $target,
					'class' => $class,
					'version' => 'wbb3-'.$this->djoVersion,
					'AktenzeichenIgnorieren' => $this->djoAktenzeichenIgnorieren)
				);
		}
		return $rueckgabe;
	}

	private function vernetzen_ueber_cache($ausgangstext) {
		$retVal = null;
		$row = WCF::getDB()->getFirstRow('
			SELECT text
			FROM '.$this->cacheTable.'
			WHERE hash = "'.WCF::getDB()->escapeString(md5($ausgangstext)).'"
				AND datetime > DATE_SUB(NOW(),INTERVAL '.$this->cacheVorhalt.' DAY)
		');
		if ($row['text'] != '<!-- idem -->') {
			$retVal = $row['text'];
		}
		return $retVal;
	}

	private function ablegen_in_cache($ausgangstext, $rueckgabe) {
		if (strpos($ausgangstext, '"highlight">') === false) {
			// Cache-Eintraege loeschen, die aelter als $this->cacheVorhalt sind
			WCF::getDB()->sendQuery('
				DELETE FROM '.$this->cacheTable.'
				WHERE datetime < DATE_SUB(NOW(),INTERVAL '.$this->cacheVorhalt.' DAY)'
			);
			if ($rueckgabe == $ausgangstext) {
				$rueckgabe = "<!-- idem -->";
			}
			$schluessel = WCF::getDB()->escapeString(md5($ausgangstext));
			$text = WCF::getDB()->escapeString($rueckgabe);
			WCF::getDB()->sendQuery('
				INSERT IGNORE INTO '.$this->cacheTable.'
				(hash, text, datetime)
				VALUES ("'.$schluessel.'", "'.$text.'", NOW())
			');
		}
	}

	private function vernetzen_ueber_dejure_org($ausgangstext, $parameter = array()) {
		// Mögliche Parameter: Anbieterkennung / Dokumentkennung / target / class / AktenzeichenIgnorieren / zeitlimit_in_sekunden
		// Hinweis: Bei Änderung der Einstellungen muß der Cache manuell gelöscht werden, damit die Änderungen für bestehende Texte wirksam werden - ansonsten werden sie erst nach 4 Tagen wirksam
		if (!preg_match("/§|&sect;|&#167;|Art\.|[\/\.] ?[0-9][0-9](?![0-9\/])| [0-9][0-9]?[\/\.] ?[0-9][0-9](?![0-9\.])| [A-Z]+ [0-9][0-9]\. ?[0-9]|[0-9][0-9],/", $ausgangstext)) {
			return $ausgangstext;
		}
		$uebergabe = "Originaltext=".urlencode($ausgangstext);
		foreach ($parameter as $option => $wert) {
			if ($option == "zeitlimit_in_sekunden") {
				$zeitlimit_in_sekunden = $wert;
			} else {
				$uebergabe .= "&".urlencode($option)."=".urlencode($wert);
			}
		}
		if (!isset($zeitlimit_in_sekunden)) {
			$zeitlimit_in_sekunden = 3;
		}
		$header = "POST http://rechtsnetz.dejure.org/dienste/vernetzung/vernetzen HTTP/1.0\r\n";
		$header .= "Content-type: application/x-www-form-urlencoded\r\n";
		$header .= "Content-length: " . strlen($uebergabe) . "\r\n\r\n";

		$fp = @fsockopen("rechtsnetz.dejure.org", 80, $errno, $errstr, $zeitlimit_in_sekunden);

		if (!$fp) { // Verbindung gescheitert
			return $ausgangstext;
		} else {
			socket_set_timeout($fp, $zeitlimit_in_sekunden, 0); // Socket nach $zeitlimit_in_sekunden Sekunden auf jeden Fall wieder frei geben
			socket_set_blocking($fp, true);
			fputs($fp, $header.$uebergabe);
			$timeOutSock = false;
			$eofSock = false;
			$rueckgabe="";
			while (!$eofSock && !$timeOutSock) {
				$rueckgabe.= fgets($fp, 1024); //
				$stSock = socket_get_status($fp);
				$eofSock = $stSock["eof"];
				$timeOutSock = $stSock["timed_out"];
			}
			fclose($fp);
			if (!preg_match("/^(.*?)\r?\n\r?\n\r?\n?(.*)/s",$rueckgabe, $rueckgabeARR)) {
				return $ausgangstext; // Zeitüberschreitung oder Verbindungsproblem
			} elseif (strpos($rueckgabeARR[1],"200 OK")===false) {
				return $ausgangstext; // sonstiges Serverproblem
			} else {
				$rueckgabe = $rueckgabeARR[2];
				if (strlen($rueckgabe) < strlen($ausgangstext)) {
					return $ausgangstext;
				}
				return $this->integritaetskontrolle_und_cache($ausgangstext, $rueckgabe);
			}
		}
	}

	private function integritaetskontrolle_und_cache($ausgangstext, $neuertext) {
		if (preg_replace("/<a href=\"http:\/\/dejure.org\/[^>]*>([^<]*)<\/a>/i", "\\1", $ausgangstext) == preg_replace("/<a href=\"http:\/\/dejure.org\/[^>]*>([^<]*)<\/a>/i", "\\1", $neuertext)) {
			$this->ablegen_in_cache($ausgangstext, $neuertext);
			return $neuertext;
		} else {
			return $ausgangstext;
		}
	}

}
?>
