<?php

// no direct access
defined( '_JEXEC' ) or die( 'Restricted Access' );

$mainframe->registerEvent('onPrepareContent', 'plgContentVernetzen');
define('DJO_VERSION', '1.21');

function plgContentVernetzen(&$row) {
	if (is_object($row)) {
		return djo_vernetzen($row->text);
	}
	return djo_vernetzen($row);
}

function djo_vernetzen(&$ausgabetext) {
	global $djoAktenzeichenIgnorieren;
	if (JString::strpos($ausgabetext, '{vernetzen=off}') !== false) {
		$ausgabetext = JString::str_ireplace('{vernetzen=off}', '', $ausgabetext);
		return true;
	}
	if (!preg_match("/|&sect;|Art\.|\/[0-9][0-9](?![0-9\/])| [0-9][0-9]?[\/\.][0-9][0-9](?![0-9\.])|[0-9], [0-9]/", $ausgabetext)) {
		//return $ausgabetext;
		return true;
	}
	$plugin = & JPluginHelper::getPlugin('content', 'vernetzung-plugin');
	$pluginParams = new JParameter($plugin->params);
	$params['vernetzungscache'] = $pluginParams->def('vernetzungscache'); # Relativer oder absoluter Name eines (les- und beschreibbaren! - Attribute: etwa 777) Verzeichnisses, mit abschlieendem "/" (bei leerer Variablen luft die Funktion ohne Cache)
	$params['anbieterkennung'] = $pluginParams->def('anbieterkennung'); # Hier eine feste Bezeichnung fr Ihren Dienst zur Kommunikation mit dejure.org festlegen (Buchstaben und Zahlen erlaubt, mindestens 5 Stellen)
	$params['kontaktemail'] = $pluginParams->def('kontaktemail'); # Wird im Rahmen der Serverkommunikation jeweils an dejure.org bertragen und dient im brigen ausschlielich der Kommunikation bei technischen Problemen.
	$params['target'] = $pluginParams->def('target'); # Zum Beispiel fr ffnen in neuem Fenster: "_blank"
	$params['class'] = $pluginParams->def('class');
	$params['linkstil'] = $pluginParams->def('linkstil');
	// Parameter des Plugins auf nderungen prfen um eventuell Lschung des Caches auszulsen.
	check_parameter($params);
	$rueckgabe = vernetzen_ueber_cache($params['vernetzungscache'], $ausgabetext);
	if (empty($rueckgabe)) {
		$rueckgabe = vernetzen_ueber_dejure_org($ausgabetext, $params['vernetzungscache'], array("Anbieterkennung" => $params['anbieterkennung']."__".$params['kontaktemail'], "target" => $params['target'], "class" => $params['class'], "version" => 'joomla-'.DJO_VERSION, 'format' => $params['linkstil'], "AktenzeichenIgnorieren" => $djoAktenzeichenIgnorieren));
	}
	if (date('G') < 9) { // Zwischen 0 und 9 Uhr ein mal alle Dateien im Cacheverzeichnis lschen, die lter als 2 Tage sind. Dies lst regelmig eine aktualisierende Neuvernetzung aus
		cache_dateien_loeschen($params['vernetzungscache'], 96); // 4*24
	}
	$ausgabetext = $rueckgabe;
}

function vernetzen_ueber_cache($vernetzungscache, $ausgangstext) {
	if ($vernetzungscache == '') {
		return '';
	}
	if (!is_dir($vernetzungscache)) {
		if (!mkdir($vernetzungscache)) {
			return '';
		}
	}
	$schluessel = strlen($ausgangstext).md5($ausgangstext);
	if (file_exists($vernetzungscache.$schluessel)) {
		if (filemtime($vernetzungscache.$schluessel) < time()-345600) { // 4*24*60*60
			return '';
		}
		return file_get_contents($vernetzungscache.$schluessel);
	}
	return '';
}

function ablegen_in_cache($vernetzungscache, $ausgangstext, $rueckgabe) {
	if (!empty($vernetzungscache)) {
		$vernetzungscache.= '/';
		$vernetzungscache = preg_replace("/\/\/+$/", "/", $vernetzungscache);
		if (is_dir($vernetzungscache)) {
			$schluessel = strlen($ausgangstext).md5($ausgangstext);
			$d = @fopen($vernetzungscache.$schluessel, "w");
			if ($d !== false) {
				fwrite($d, $rueckgabe);
				fclose($d);
			}
		}
	}
}

function cache_dateien_loeschen($verzeichnis = null, $stunden = null) {
	if (empty($verzeichnis) || !is_numeric($stunden)) {
		return;
	}
	$verzeichnis.= '/';
	$verzeichnis = preg_replace("/\/\/+$/", "/", $verzeichnis);
	if (is_dir($verzeichnis)) {
		if (!file_exists($verzeichnis.'cache_status')) {
			cache_status_datei($verzeichnis);
			return;
		}
		$cache_status = trim(file_get_contents($verzeichnis.'cache_status'));
		if ((time()-$cache_status) > 8600 || $stunden == -1) { // 24*60*60 -- Wenn das letzte Loeschen 24h her ist
			$dir_handle = opendir($verzeichnis);
			$geloescht = array();
			$loeschzeit = (time() - ($stunden * 3600));
			while (false !== ($datei = readdir($dir_handle))) {
				if (!in_array($datei, array('.', '..')) && $datei != 'cache_status') {
					$file_time = 0;
					if ($stunden != -1) {
						$file_time = filemtime($verzeichnis.$datei);
					}
					// Datei aelter als n Stunden, dann loeschen
					if ($file_time < $loeschzeit || $stunden == -1) {
						unlink($verzeichnis.$datei);
						//$geloescht[] = $verzeichnis.$datei;
					}
				}
			}
			closedir($dir_handle);
			cache_status_datei($verzeichnis);
			//return $geloescht;
		}
	}
}

function cache_status_datei($verzeichnis) {
	$cache_zeitstempel = mktime(0, 0, 0, date('m'), date('d'), date('Y'));
	$file_handle = @fopen($verzeichnis.'cache_status', 'w');
	if ($file_handle) {
		fputs($file_handle, $cache_zeitstempel);
		fclose($file_handle);
	}
}

function check_parameter($params) {
	$check_file = 'tmp/vernetzung_parameter';
	$set_params = serialize($params);
	if (file_exists($check_file)) {
		$check_params = trim(file_get_contents($check_file));
		if ($set_params != $check_params) {
			$check_params = unserialize($check_params);
			cache_dateien_loeschen($check_params['vernetzungscache'], -1);
			if ($check_params['vernetzungscache'] != $params['vernetzungscache']) {
				@rmdir($check_params['vernetzungscache']);
			}
		} else {
			return true;
		}
	}
	$handle = fopen($check_file, 'w');
	fwrite($handle, $set_params);
	fclose($handle);

}

function integritaetskontrolle_und_cache($vernetzungscache, $ausgangstext, $neuertext) {
	if (preg_replace("/<a href=\"http:\/\/dejure.org\/[^>]*>([^<]*)<\/a>/i", "\\1", $ausgangstext) == preg_replace("/<a href=\"http:\/\/dejure.org\/[^>]*>([^<]*)<\/a>/i", "\\1", $neuertext)) {
		ablegen_in_cache($vernetzungscache, $ausgangstext, $neuertext);
		return $neuertext;
	}
	else {
		return $ausgangstext;
	}
}

function vernetzen_ueber_dejure_org($ausgangstext, $vernetzungscache, $parameter = array()) {
	// Mgliche Parameter: Anbieterkennung / Dokumentkennung / target / class / AktenzeichenIgnorieren / zeitlimit_in_sekunden
	// Hinweis: Bei nderung der Einstellungen mu der Cache manuell gelscht werden
	$uebergabe = "Originaltext=".urlencode($ausgangstext);
	foreach ($parameter as $option => $wert) {
		if ($option == "zeitlimit_in_sekunden") {
			$zeitlimit_in_sekunden = $wert;
		}
		else {
			$uebergabe .= "&".urlencode($option)."=".urlencode($wert);
		}
	}
	if (!isset($zeitlimit_in_sekunden)) {
		$zeitlimit_in_sekunden = 3;
	}
	$header = "POST http://rechtsnetz.dejure.org/dienste/vernetzung/vernetzen HTTP/1.0\r\n";
	$header .= "Content-type: application/x-www-form-urlencoded\r\n";
	$header .= "Content-length: " . strlen($uebergabe) . "\r\n\r\n";

	$fp = @fsockopen("rechtsnetz.dejure.org", 80, $errno, $errstr, $zeitlimit_in_sekunden);

	if (!$fp) { // Verbindung gescheitert
		return $ausgangstext;
	}
	else {
		socket_set_timeout($fp, $zeitlimit_in_sekunden, 0); // Socket nach $zeitlimit_in_sekunden Sekunden auf jeden Fall wieder frei geben
		socket_set_blocking($fp, true);
		fputs($fp, $header.$uebergabe);
		$timeOutSock = false;
		$eofSock = false;
		$rueckgabe = '';
		while (!$eofSock && !$timeOutSock) {
			$rueckgabe.= fgets($fp, 1024); //
			$stSock = socket_get_status($fp);
			$eofSock = $stSock["eof"];
			$timeOutSock = $stSock["timed_out"];
		}
		fclose($fp);
		if (!preg_match("/^(.*?)\r?\n\r?\n\r?\n?(.*)/s",$rueckgabe, $rueckgabeARR)) {
			return $ausgangstext; // Zeitberschreitung oder Verbindungsproblem
		}
		else if (strpos($rueckgabeARR[1],"200 OK")===false) {
			return $ausgangstext; // sonstiges Serverproblem
		}
		else {
			$rueckgabe = $rueckgabeARR[2];
			if (strlen($rueckgabe) < strlen($ausgangstext)) {
				return $ausgangstext;
			}
			return integritaetskontrolle_und_cache($vernetzungscache, $ausgangstext, $rueckgabe);
		}
	}
}
?>
