// MIT License
//
// Copyright (c) 2017-2019 MessageKit
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

import Foundation

/// An enum representing the kind of message and its underlying kind.
public enum MessageKind {
  /// A standard text message.
  ///
  /// - Note: The font used for this message will be the value of the
  /// `messageLabelFont` property in the `MessagesCollectionViewFlowLayout` object.
  ///
  /// Using `MessageKind.attributedText(NSAttributedString)` doesn't require you
  /// to set this property and results in higher performance.
  case text(String)

  /// A message with attributed text.
  case attributedText(NSAttributedString)

  /// A photo message.
  case photo(MediaItem)

  /// A video message.
  case video(MediaItem)

  /// A location message.
  case location(LocationItem)

  /// An emoji message.
  case emoji(String)

  /// An audio message.
  case audio(AudioItem)

  /// A contact message.
  case contact(ContactItem)

  /// A link preview message.
  case linkPreview(LinkItem)

  /// A custom message.
  /// - Note: Using this case requires that you implement the following methods and handle this case:
  ///   - MessagesDataSource: customCell(for message: MessageType, at indexPath: IndexPath, in messagesCollectionView: MessagesCollectionView) -> UICollectionViewCell
  ///   - MessagesLayoutDelegate: customCellSizeCalculator(for message: MessageType, at indexPath: IndexPath, in messagesCollectionView: MessagesCollectionView) -> CellSizeCalculator
  case custom(Any?)

  // MARK: - Not supported yet

//    case system(String)
//
//    case placeholder
}
